/*BEGIN_LEGAL 
Intel Open Source License 

Copyright (c) 2002-2012 Intel Corporation. All rights reserved.
 
Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.  Redistributions
in binary form must reproduce the above copyright notice, this list of
conditions and the following disclaimer in the documentation and/or
other materials provided with the distribution.  Neither the name of
the Intel Corporation nor the names of its contributors may be used to
endorse or promote products derived from this software without
specific prior written permission.
 
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE INTEL OR
ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
END_LEGAL */
/*
 * This tool mimics the behavior of TPSS on Linux by adding probes to various libc functions.
 * However, in this tool these probes are merely empty wrappers that call the original functions.
 * The objective of the test is to verify that probe generation and insertion don't cause Pin
 * to crash.
 *
 * The code was automatically generated by the pyCG package written by Gal Diskin (2008) and
 * was manually modified by Naftaly Shalev.
 *
 */

#include "pin.H"
#include <iostream>
#include <fstream>
#include <string>
#include <ctime>
#include <sys/types.h>
#include <sys/timeb.h>
#include <rpc/rpc.h>
#include <rpc/pmap_clnt.h>
#include <semaphore.h>
#include <dlfcn.h>
#include <signal.h>
#include <poll.h>

typedef int * INT_PTR;

ofstream OutFile;

/* ===================================================================== */
/* Commandline Switches                                                  */
/* ===================================================================== */

KNOB<string> KnobOutputFile(KNOB_MODE_WRITEONCE, "pintool",
    "o", "tpss_lin.txt", "specify tool log file name");
    
/* ===================================================================== */
/* Utility functions                                                     */
/* ===================================================================== */

// Print help information
INT32 Usage()
{
    cerr << "This tool mimics the behavior of TPSS on Linux by adding probes to various libc functions." << endl;
    cerr << KNOB_BASE::StringKnobSummary();
    cerr << endl;
    return 1;
}

// Utility function to return the time
string CurrentTime()
{
    char tmpbuf[128];
    time_t thetime = time(NULL);
    ctime_r(&thetime, tmpbuf);
    return tmpbuf;
}


/* ===================================================================== */
/* Function signatures - these functions will be probed                  */
/* ===================================================================== */

enum clnt_stat (*fptrclnt_broadcast)( u_long ,  u_long ,  u_long , xdrproc_t , caddr_t , xdrproc_t , caddr_t , resultproc_t );

int (*fptrsem_wait)(sem_t * );

int (*fptrregisterrpc)(rpcprog_t , rpcvers_t , rpcproc_t , char *(*)(void *) , xdrproc_t , xdrproc_t );

int (*fptrfclose)(FILE * );

int (*fptrpthread_barrier_destroy)(pthread_barrier_t * );

int (*fptrsleep)(unsigned int );

int (*fptrsem_destroy)(sem_t * );

size_t (*fptrfwrite)(__const void *__restrict , size_t , size_t , FILE *__restrict );

bool_t (*fptrpmap_set)( u_long ,  u_long , int , u_short );

ssize_t (*fptrsend)(int , __const void * , size_t , int );

int (*fptrpthread_mutex_init)(pthread_mutex_t * , __const pthread_mutexattr_t * );

int (*fptrcallrpc)(__const char * ,  u_long ,  u_long ,  u_long ,  xdrproc_t , __const char * ,  xdrproc_t , char * );

int (*fptrsem_init)(sem_t * , int , unsigned int );

enum clnt_stat (*fptrpmap_rmtcall)(struct sockaddr_in * ,  u_long ,  u_long ,  u_long , xdrproc_t , caddr_t , xdrproc_t , caddr_t , struct timeval , u_long * );

SVCXPRT * (*fptrsvctcp_create)(int , u_int , u_int );

ssize_t (*fptrread)(int , void * , size_t );

int (*fptrdladdr1)(__const void * , Dl_info * , void ** , int );

int (*fptrdlclose)(void * );

int (*fptrpthread_mutex_lock)(pthread_mutex_t * );

__sighandler_t (*fptrsignal)(int , __sighandler_t );

wint_t (*fptrfgetwc)(__FILE * );

int (*fptrpthread_cancel)(pthread_t );

int (*fptrpthread_cond_wait)(pthread_cond_t *__restrict , pthread_mutex_t *__restrict );

ssize_t (*fptrsendto)(int , __const void * , size_t , int , __CONST_SOCKADDR_ARG , socklen_t );

wchar_t * (*fptrfgetws)(wchar_t *__restrict , int , __FILE *__restrict );

void (*fptrfgetc)(__FILE * );

int (*fptrpthread_cond_signal)(pthread_cond_t * );

int (*fptrconnect)(int , __CONST_SOCKADDR_ARG , socklen_t );

char * (*fptrfgets)(char *__restrict , int , FILE *__restrict );

int (*fptrclose)(int );

int (*fptrgetch)();

ssize_t (*fptrrecvfrom)(int , void *__restrict , size_t , int , __SOCKADDR_ARG , socklen_t *__restrict );

FILE * (*fptrfopen)(__const char *__restrict , __const char *__restrict );

int (*fptrpthread_barrier_wait)(pthread_barrier_t * );

int (*fptrpthread_spin_destroy)(pthread_spinlock_t * );

int (*fptrpthread_key_delete)(pthread_key_t );

void (*fptrexit)(int );

int (*fptrpthread_setspecific)(pthread_key_t , __const void * );

int (*fptrpthread_rwlock_timedrdlock)(pthread_rwlock_t *__restrict , __const struct timespec *__restrict );

int (*fptrpthread_rwlock_destroy)(pthread_rwlock_t * );

void (*fptrpthread_exit)(void* );

wint_t (*fptrgetwchar)();

ssize_t (*fptrrecv)(int , void * , size_t , int );

void * (*fptrdlopen)(__const char * , int );

int (*fptrsocket)(int , int , int );

SVCXPRT * (*fptrsvcraw_create)();

CLIENT * (*fptrclntudp_bufcreate)(struct sockaddr_in * , u_long , u_long , struct timeval , int * , u_int , u_int );

void (*fptr_exit)(int );

__pid_t (*fptrvfork)();

SVCXPRT * (*fptrsvcudp_bufcreate)(int , u_int , u_int );

SVCXPRT * (*fptrsvcudp_create)(int );

int (*fptrsem_post)(sem_t * );

int (*fptrshutdown)(int , int );

int (*fptrpthread_create)(pthread_t *__restrict , __const pthread_attr_t *__restrict , void *(*)(void *) , void *__restrict );

int (*fptrpoll)(struct pollfd * , nfds_t , int );

int (*fptropen)(__const char * , int , mode_t );

int (*fptrselect)(int , fd_set *__restrict , fd_set *__restrict , fd_set *__restrict , struct timeval *__restrict );

int (*fptrgetchar)();

int (*fptrpthread_spin_init)(pthread_spinlock_t * , int );

int (*fptrsigprocmask)(int , __const sigset_t *__restrict , sigset_t *__restrict );

FILE * (*fptrfdopen)(int , __const char * );

int (*fptrpthread_key_create)(pthread_key_t * , void (*) (void *) );

int (*fptrnanosleep)(__const struct timespec * , struct timespec * );

int (*fptrsigpending)(sigset_t * );

int (*fptrpthread_cond_timedwait)(pthread_cond_t *__restrict , pthread_mutex_t *__restrict , __const struct timespec *__restrict );

__pid_t (*fptrfork)();

int (*fptrpthread_cond_broadcast)(pthread_cond_t * );

int (*fptrpthread_mutex_unlock)(pthread_mutex_t * );

int (*fptrpthread_sigmask)(int , __const sigset_t *__restrict , sigset_t *__restrict );

int (*fptrexecve)(__const char * , char *__const* , char *__const* );

int (*fptr_IO_getc)(FILE * );

int (*fptrdladdr)(__const void * , Dl_info * );

int (*fptrpthread_mutex_destroy)(pthread_mutex_t * );

int (*fptrpthread_rwlock_init)(pthread_rwlock_t *__restrict , __const pthread_rwlockattr_t *__restrict );

struct pmaplist * (*fptrpmap_getmaps)(struct sockaddr_in * );

int (*fptrpthread_rwlock_unlock)(pthread_rwlock_t * );

CLIENT * (*fptrclntraw_create)( u_long ,  u_long );

void * (*fptrdlsym)(void *__restrict , __const char *__restrict );

size_t (*fptrfread)(void *__restrict , size_t , size_t , FILE *__restrict );

int (*fptraccept)(int , __SOCKADDR_ARG , socklen_t *__restrict );

int (*fptrpselect)(int , fd_set *__restrict , fd_set *__restrict , fd_set *__restrict , const struct timespec *__restrict , const __sigset_t *__restrict );

void (*fptrabort)();

int (*fptrpthread_cond_destroy)(pthread_cond_t * );

int (*fptrmvgetch)(int , int );

int (*fptrpthread_spin_lock)(pthread_spinlock_t * );

wint_t (*fptrgetwc)(__FILE * );

CLIENT * (*fptrclntudp_create)(struct sockaddr_in * , u_long , u_long , struct timeval , int * );

ssize_t (*fptrwrite)(int , __const void * , size_t );

int (*fptrsigaction)(int , __const struct sigaction *__restrict , struct sigaction *__restrict );

void * (*fptrdlvsym)(void *__restrict , __const char *__restrict , __const char *__restrict );

int (*fptrpthread_mutex_timedlock)(pthread_mutex_t *__restrict , __const struct timespec *__restrict );

char * (*fptrgets)(char * );

int (*fptrgetw)(FILE * );

int (*fptrpthread_barrier_init)(pthread_barrier_t *__restrict , __const pthread_barrierattr_t *__restrict , unsigned int );

int (*fptrsigsuspend)(__const sigset_t * );

bool_t (*fptrsvc_sendreply)(SVCXPRT * , xdrproc_t , caddr_t );

int (*fptrpthread_spin_unlock)(pthread_spinlock_t * );

int (*fptrpthread_rwlock_rdlock)(pthread_rwlock_t * );

int (*fptrpthread_rwlock_wrlock)(pthread_rwlock_t * );

int (*fptrpthread_join)(pthread_t , void** );

int (*fptrpthread_cond_init)(pthread_cond_t *__restrict , __const pthread_condattr_t *__restrict );

void (*fptrsvc_run)();

int (*fptrsetitimer)(__itimer_which_t , __const struct itimerval *__restrict , struct itimerval *__restrict );

SVCXPRT * (*fptrsvcfd_create)(int , u_int , u_int );

u_short (*fptrpmap_getport)(struct sockaddr_in * ,  u_long ,  u_long , u_int );

int (*fptrpipe)(int[2] );

int (*fptrpthread_rwlock_timedwrlock)(pthread_rwlock_t *__restrict , __const struct timespec *__restrict );


/* ===================================================================== */
/* Probes - implementation of the wrapper functions                      */
/* ===================================================================== */

enum clnt_stat myclnt_broadcast( u_long __prog,  u_long __vers,  u_long __proc, xdrproc_t __xargs, caddr_t __argsp, xdrproc_t __xresults, caddr_t __resultsp, resultproc_t __eachresult)
{
   OutFile << CurrentTime() << "myclnt_broadcast called " << endl;
   OutFile.flush();
   enum clnt_stat res = fptrclnt_broadcast(__prog, __vers, __proc, __xargs, __argsp, __xresults, __resultsp, __eachresult);
   
   return res; 
}

int mysem_wait(sem_t * __sem)
{
   OutFile << CurrentTime() << "mysem_wait called " << endl;
   OutFile.flush();
   int res = fptrsem_wait(__sem);
   
   return res; 
}

int myregisterrpc(rpcprog_t __registerrpc_param1, rpcvers_t __registerrpc_param2, rpcproc_t __registerrpc_param3, char *(*__registerrpc_param4)(void *), xdrproc_t __registerrpc_param5, xdrproc_t __registerrpc_param6)
{
   OutFile << CurrentTime() << "myregisterrpc called " << endl;
   OutFile.flush();
   int res = fptrregisterrpc(__registerrpc_param1, __registerrpc_param2, __registerrpc_param3, __registerrpc_param4, __registerrpc_param5, __registerrpc_param6);
   
   return res; 
}

int myfclose(FILE * __stream)
{
   OutFile << CurrentTime() << "myfclose called " << endl;
   OutFile.flush();
   int res = fptrfclose(__stream);
   
   return res; 
}

int mypthread_barrier_destroy(pthread_barrier_t * __barrier)
{
   OutFile << CurrentTime() << "mypthread_barrier_destroy called " << endl;
   OutFile.flush();
   int res = fptrpthread_barrier_destroy(__barrier);
   
   return res; 
}

int mysleep(unsigned int __seconds)
{
   OutFile << CurrentTime() << "mysleep called " << endl;
   OutFile.flush();
   int res = fptrsleep(__seconds);
   
   return res; 
}

int mysem_destroy(sem_t * __sem)
{
   OutFile << CurrentTime() << "mysem_destroy called " << endl;
   OutFile.flush();
   int res = fptrsem_destroy(__sem);
   
   return res; 
}

size_t myfwrite(__const void *__restrict __ptr, size_t __size, size_t __n, FILE *__restrict __s)
{
   OutFile << CurrentTime() << "myfwrite called " << endl;
   OutFile.flush();
   size_t res = fptrfwrite(__ptr, __size, __n, __s);
   
   return res; 
}

bool_t mypmap_set( u_long __program,  u_long __vers, int __protocol, u_short __port)
{
   OutFile << CurrentTime() << "mypmap_set called " << endl;
   OutFile.flush();
   bool_t res = fptrpmap_set(__program, __vers, __protocol, __port);
   
   return res; 
}

ssize_t mysend(int __fd, __const void * __buf, size_t __n, int __flags)
{
   OutFile << CurrentTime() << "mysend called " << endl;
   OutFile.flush();
   ssize_t res = fptrsend(__fd, __buf, __n, __flags);
   
   return res; 
}

int mypthread_mutex_init(pthread_mutex_t * __mutex, __const pthread_mutexattr_t * __mutexattr)
{
   OutFile << CurrentTime() << "mypthread_mutex_init called " << endl;
   OutFile.flush();
   int res = fptrpthread_mutex_init(__mutex, __mutexattr);
   
   return res; 
}

int mycallrpc(__const char * __host,  u_long __prognum,  u_long __versnum,  u_long __procnum,  xdrproc_t __inproc, __const char * __in,  xdrproc_t __outproc, char * __out)
{
   OutFile << CurrentTime() << "mycallrpc called " << endl;
   OutFile.flush();
   int res = fptrcallrpc(__host, __prognum, __versnum, __procnum, __inproc, __in, __outproc, __out);
   
   return res; 
}

int mysem_init(sem_t * __sem, int __pshared, unsigned int __value)
{
   OutFile << CurrentTime() << "mysem_init called " << endl;
   OutFile.flush();
   int res = fptrsem_init(__sem, __pshared, __value);
   
   return res; 
}

enum clnt_stat mypmap_rmtcall(struct sockaddr_in * __addr,  u_long __prog,  u_long __vers,  u_long __proc, xdrproc_t __xdrargs, caddr_t __argsp, xdrproc_t __xdrres, caddr_t __resp, struct timeval __tout, u_long * __port_ptr)
{
   OutFile << CurrentTime() << "mypmap_rmtcall called " << endl;
   OutFile.flush();
   enum clnt_stat res = fptrpmap_rmtcall(__addr, __prog, __vers, __proc, __xdrargs, __argsp, __xdrres, __resp, __tout, __port_ptr);
   
   return res; 
}

SVCXPRT * mysvctcp_create(int __sock, u_int __sendsize, u_int __recvsize)
{
   OutFile << CurrentTime() << "mypmap_rmtcall called " << endl;
   OutFile.flush();
   SVCXPRT * res = fptrsvctcp_create(__sock, __sendsize, __recvsize);
   
   return res; 
}

ssize_t myread(int __fd, void * __buf, size_t __nbytes)
{
   OutFile << CurrentTime() << "myread called " << endl;
   OutFile.flush();
   ssize_t res = fptrread(__fd, __buf, __nbytes);
   
   return res; 
}

int mydladdr1(__const void * __address, Dl_info * __info, void ** __extra_info, int __flags)
{
   OutFile << CurrentTime() << "mydladdr1 called " << endl;
   OutFile.flush();
   int res = fptrdladdr1(__address, __info, __extra_info, __flags);
   
   return res; 
}

int mydlclose(void * __handle)
{
   OutFile << CurrentTime() << "mydlclose called " << endl;
   OutFile.flush();
   int res = fptrdlclose(__handle);
   
   return res; 
}

int mypthread_mutex_lock(pthread_mutex_t * __mutex)
{
   OutFile << CurrentTime() << "mypthread_mutex_lock called " << endl;
   OutFile.flush();
   int res = fptrpthread_mutex_lock(__mutex);
   
   return res; 
}

__sighandler_t mysignal(int __sig, __sighandler_t __handler)
{
   OutFile << CurrentTime() << "mysignal called " << endl;
   OutFile.flush();
   __sighandler_t res = fptrsignal(__sig, __handler);
   
   return res; 
}

wint_t myfgetwc(__FILE * __stream)
{
   OutFile << CurrentTime() << "myfgetwc called " << endl;
   OutFile.flush();
   wint_t res = fptrfgetwc(__stream);
   
   return res; 
}

int mypthread_cancel(pthread_t __thr)
{
   OutFile << CurrentTime() << "mypthread_cancel called " << endl;
   OutFile.flush();
   int res = fptrpthread_cancel(__thr);
   
   return res; 
}

int mypthread_cond_wait(pthread_cond_t *__restrict __cond, pthread_mutex_t *__restrict __mutex)
{
   OutFile << CurrentTime() << "mypthread_cond_wait called " << endl;
   OutFile.flush();
   int res = fptrpthread_cond_wait(__cond, __mutex);
   
   return res; 
}

ssize_t mysendto(int __fd, __const void * __buf, size_t __n, int __flags, __CONST_SOCKADDR_ARG __addr, socklen_t __addr_len)
{
   OutFile << CurrentTime() << "mysendto called " << endl;
   OutFile.flush();
   ssize_t res = fptrsendto(__fd, __buf, __n, __flags, __addr, __addr_len);
   
   return res; 
}

wchar_t * myfgetws(wchar_t *__restrict __ws, int __n, __FILE *__restrict __stream)
{
   OutFile << CurrentTime() << "myfgetws called " << endl;
   OutFile.flush();
   wchar_t * res = fptrfgetws(__ws, __n, __stream);
   
   return res; 
}

void myfgetc(__FILE * __stream)
{
   OutFile << CurrentTime() << "myfgetc called " << endl;
   OutFile.flush();
   fptrfgetc(__stream);
   
}

int mypthread_cond_signal(pthread_cond_t * __cond)
{
   OutFile << CurrentTime() << "mypthread_cond_signal called " << endl;
   OutFile.flush();
   int res = fptrpthread_cond_signal(__cond);
   
   return res; 
}

int myconnect(int __fd, __CONST_SOCKADDR_ARG __addr, socklen_t __len)
{
   OutFile << CurrentTime() << "myconnect called " << endl;
   OutFile.flush();
   int res = fptrconnect(__fd, __addr, __len);
   
   return res; 
}

char * myfgets(char *__restrict __s, int __n, FILE *__restrict __stream)
{
   OutFile << CurrentTime() << "myfgets called " << endl;
   OutFile.flush();
   char * res = fptrfgets(__s, __n, __stream);
   
   return res; 
}

int myclose(int __fd)
{
   OutFile << CurrentTime() << "myclose called " << endl;
   OutFile.flush();
   int res = fptrclose(__fd);
   
   return res; 
}

int mygetch()
{
   OutFile << CurrentTime() << "mygetch called " << endl;
   OutFile.flush();
   int res = fptrgetch();
   
   return res; 
}

ssize_t myrecvfrom(int __fd, void *__restrict __buf, size_t __n, int __flags, __SOCKADDR_ARG __addr, socklen_t *__restrict __addr_len)
{
   OutFile << CurrentTime() << "myrecvfrom called " << endl;
   OutFile.flush();
   ssize_t res = fptrrecvfrom(__fd, __buf, __n, __flags, __addr, __addr_len);
   
   return res; 
}

FILE * myfopen(__const char *__restrict __filename, __const char *__restrict __modes)
{
   OutFile << CurrentTime() << "myfopen called " << endl;
   OutFile.flush();
   FILE * res = fptrfopen(__filename, __modes);
   
   return res; 
}

int mypthread_barrier_wait(pthread_barrier_t * __barrier)
{
   OutFile << CurrentTime() << "mypthread_barrier_wait called " << endl;
   OutFile.flush();
   int res = fptrpthread_barrier_wait(__barrier);
   
   return res; 
}

int mypthread_spin_destroy(pthread_spinlock_t * __lock)
{
   OutFile << CurrentTime() << "mypthread_spin_destroy called " << endl;
   OutFile.flush();
   int res = fptrpthread_spin_destroy(__lock);
   
   return res; 
}

int mypthread_key_delete(pthread_key_t __key)
{
   OutFile << CurrentTime() << "mypthread_key_delete called " << endl;
   OutFile.flush();
   int res = fptrpthread_key_delete(__key);
   
   return res; 
}

void myexit(int __status)
{
   OutFile << CurrentTime() << "myexit called " << endl;
   OutFile.flush();
   fptrexit(__status);
   
}

int mypthread_setspecific(pthread_key_t __key, __const void * __pointer)
{
   OutFile << CurrentTime() << "mypthread_setspecific called " << endl;
   OutFile.flush();
   int res = fptrpthread_setspecific(__key, __pointer);
   
   return res; 
}

int mypthread_rwlock_timedrdlock(pthread_rwlock_t *__restrict __rwlock, __const struct timespec *__restrict __abstime)
{
   OutFile << CurrentTime() << "mypthread_rwlock_timedrdlock called " << endl;
   OutFile.flush();
   int res = fptrpthread_rwlock_timedrdlock(__rwlock, __abstime);
   
   return res; 
}

int mypthread_rwlock_destroy(pthread_rwlock_t * __rwlock)
{
   OutFile << CurrentTime() << "mypthread_rwlock_destroy called " << endl;
   OutFile.flush();
   int res = fptrpthread_rwlock_destroy(__rwlock);
   
   return res; 
}

void mypthread_exit(void* __retval)
{
   OutFile << CurrentTime() << "mypthread_exit called " << endl;
   OutFile.flush();
   fptrpthread_exit(__retval);
   
}

wint_t mygetwchar()
{
   OutFile << CurrentTime() << "mygetwchar called " << endl;
   OutFile.flush();
   wint_t res = fptrgetwchar();
   
   return res; 
}

ssize_t myrecv(int __fd, void * __buf, size_t __n, int __flags)
{
   OutFile << CurrentTime() << "myrecv called " << endl;
   OutFile.flush();
   ssize_t res = fptrrecv(__fd, __buf, __n, __flags);
   
   return res; 
}

void * mydlopen(__const char * __file, int __mode)
{
   OutFile << CurrentTime() << "mydlopen called " << endl;
   OutFile.flush();
   void * res = fptrdlopen(__file, __mode);
   
   return res; 
}

int mysocket(int __domain, int __type, int __protocol)
{
   OutFile << CurrentTime() << "mysocket called " << endl;
   OutFile.flush();
   int res = fptrsocket(__domain, __type, __protocol);
   
   return res; 
}

SVCXPRT * mysvcraw_create()
{
   OutFile << CurrentTime() << "mysvcraw_create called " << endl;
   OutFile.flush();
   SVCXPRT * res = fptrsvcraw_create();
   
   return res; 
}

CLIENT * myclntudp_bufcreate(struct sockaddr_in * __raddr, u_long __program, u_long __version, struct timeval __wait_resend, int * __sockp, u_int __sendsz, u_int __recvsz)
{
   OutFile << CurrentTime() << "myclntudp_bufcreate called " << endl;
   OutFile.flush();
   CLIENT * res = fptrclntudp_bufcreate(__raddr, __program, __version, __wait_resend, __sockp, __sendsz, __recvsz);
   
   return res; 
}

void my_exit(int __status)
{
   OutFile << CurrentTime() << "my_exit called " << endl;
   OutFile.flush();
   fptr_exit(__status);
   
}

__pid_t myvfork()
{
   OutFile << CurrentTime() << "myvfork called " << endl;
   OutFile.flush();
   __pid_t res = fptrvfork();
   
   return res; 
}

SVCXPRT * mysvcudp_bufcreate(int __sock, u_int __sendsz, u_int __recvsz)
{
   OutFile << CurrentTime() << "mysvcudp_bufcreate called " << endl;
   OutFile.flush();
   SVCXPRT * res = fptrsvcudp_bufcreate(__sock, __sendsz, __recvsz);
   
   return res; 
}

SVCXPRT * mysvcudp_create(int __sock)
{
   OutFile << CurrentTime() << "mysvcudp_create called " << endl;
   OutFile.flush();
   SVCXPRT * res = fptrsvcudp_create(__sock);
   
   return res; 
}

int mysem_post(sem_t * __sem)
{
   OutFile << CurrentTime() << "mysem_post called " << endl;
   OutFile.flush();
   int res = fptrsem_post(__sem);
   
   return res; 
}

int myshutdown(int __fd, int __how)
{
   OutFile << CurrentTime() << "myshutdown called " << endl;
   OutFile.flush();
   int res = fptrshutdown(__fd, __how);
   
   return res; 
}

int mypthread_create(pthread_t *__restrict __newthread, __const pthread_attr_t *__restrict __attr, void *(*__start_routine)(void *), void *__restrict __arg)
{
   OutFile << CurrentTime() << "mypthread_create called " << endl;
   OutFile.flush();
   int res = fptrpthread_create(__newthread, __attr, __start_routine, __arg);
   
   return res; 
}

int mypoll(struct pollfd * __fds, nfds_t __nfds, int __timeout)
{
   OutFile << CurrentTime() << "mypoll called " << endl;
   OutFile.flush();
   int res = fptrpoll(__fds, __nfds, __timeout);
   
   return res; 
}

int myopen(__const char * __file, int __flags, mode_t __mode)
{
   OutFile << CurrentTime() << "myopen called " << endl;
   OutFile.flush();
   int res = fptropen(__file, __flags, __mode);
   
   return res; 
}

int myselect(int __nfds, fd_set *__restrict __readfds, fd_set *__restrict __writefds, fd_set *__restrict __exceptfds, struct timeval *__restrict __timeout)
{
   OutFile << CurrentTime() << "myselect called " << endl;
   OutFile.flush();
   int res = fptrselect(__nfds, __readfds, __writefds, __exceptfds, __timeout);
   
   return res; 
}

int mygetchar()
{
   OutFile << CurrentTime() << "mygetchar called " << endl;
   OutFile.flush();
   int res = fptrgetchar();
   
   return res; 
}

int mypthread_spin_init(pthread_spinlock_t * __lock, int __pshared)
{
   OutFile << CurrentTime() << "mypthread_spin_init called " << endl;
   OutFile.flush();
   int res = fptrpthread_spin_init(__lock, __pshared);
   
   return res; 
}

int mysigprocmask(int __how, __const sigset_t *__restrict __set, sigset_t *__restrict __oset)
{
   OutFile << CurrentTime() << "mysigprocmask called " << endl;
   OutFile.flush();
   int res = fptrsigprocmask(__how, __set, __oset);
   
   return res; 
}

FILE * myfdopen(int __fd, __const char * __modes)
{
   OutFile << CurrentTime() << "myfdopen called " << endl;
   OutFile.flush();
   FILE * res = fptrfdopen(__fd, __modes);
   
   return res; 
}

int mypthread_key_create(pthread_key_t * __key, void (*__destr_function) (void *) )
{
   OutFile << CurrentTime() << "mypthread_key_create called " << endl;
   OutFile.flush();
   int res = fptrpthread_key_create(__key, __destr_function);
   
   return res; 
}

int mynanosleep(__const struct timespec * __requested_time, struct timespec * __remaining)
{
   OutFile << CurrentTime() << "mynanosleep called " << endl;
   OutFile.flush();
   int res = fptrnanosleep(__requested_time, __remaining);
   
   return res; 
}

int mysigpending(sigset_t * __set)
{
   OutFile << CurrentTime() << "mysigpending called " << endl;
   OutFile.flush();
   int res = fptrsigpending(__set);
   
   return res; 
}

int mypthread_cond_timedwait(pthread_cond_t *__restrict __cond, pthread_mutex_t *__restrict __mutex, __const struct timespec *__restrict __abstime)
{
   OutFile << CurrentTime() << "mypthread_cond_timedwait called " << endl;
   OutFile.flush();
   int res = fptrpthread_cond_timedwait(__cond, __mutex, __abstime);
   
   return res; 
}

__pid_t myfork()
{
   OutFile << CurrentTime() << "myfork called " << endl;
   OutFile.flush();
   __pid_t res = fptrfork();
   
   return res; 
}

int mypthread_cond_broadcast(pthread_cond_t * __cond)
{
   OutFile << CurrentTime() << "mypthread_cond_broadcast called " << endl;
   OutFile.flush();
   int res = fptrpthread_cond_broadcast(__cond);
   
   return res; 
}

int mypthread_mutex_unlock(pthread_mutex_t * __mutex)
{
   OutFile << CurrentTime() << "mypthread_mutex_unlock called " << endl;
   OutFile.flush();
   int res = fptrpthread_mutex_unlock(__mutex);
   
   return res; 
}

int mypthread_sigmask(int __how, __const sigset_t *__restrict __newmask, sigset_t *__restrict __oldmask)
{
   OutFile << CurrentTime() << "mypthread_sigmask called " << endl;
   OutFile.flush();
   int res = fptrpthread_sigmask(__how, __newmask, __oldmask);
   
   return res; 
}

int myexecve(__const char * __path, char *__const* __argv, char *__const* __envp)
{
   OutFile << CurrentTime() << "myexecve called " << endl;
   OutFile.flush();
   int res = fptrexecve(__path, __argv, __envp);
   
   return res; 
}

int my_IO_getc(FILE * __stream)
{
   OutFile << CurrentTime() << "my_IO_getc called " << endl;
   OutFile.flush();
   int res = fptr_IO_getc(__stream);
   
   return res; 
}

int mydladdr(__const void * __address, Dl_info * __info)
{
   OutFile << CurrentTime() << "mydladdr called " << endl;
   OutFile.flush();
   int res = fptrdladdr(__address, __info);
   
   return res; 
}

int mypthread_mutex_destroy(pthread_mutex_t * __mutex)
{
   OutFile << CurrentTime() << "mypthread_mutex_destroy called " << endl;
   OutFile.flush();
   int res = fptrpthread_mutex_destroy(__mutex);
   
   return res; 
}

int mypthread_rwlock_init(pthread_rwlock_t *__restrict __rwlock, __const pthread_rwlockattr_t *__restrict __attr)
{
   OutFile << CurrentTime() << "mypthread_rwlock_init called " << endl;
   OutFile.flush();
   int res = fptrpthread_rwlock_init(__rwlock, __attr);
   
   return res; 
}

struct pmaplist * mypmap_getmaps(struct sockaddr_in * __address)
{
   OutFile << CurrentTime() << "mypmap_getmaps called " << endl;
   OutFile.flush();
   struct pmaplist * res = fptrpmap_getmaps(__address);
   
   return res; 
}

int mypthread_rwlock_unlock(pthread_rwlock_t * __rwlock)
{
   OutFile << CurrentTime() << "mypthread_rwlock_unlock called " << endl;
   OutFile.flush();
   int res = fptrpthread_rwlock_unlock(__rwlock);
   
   return res; 
}

CLIENT * myclntraw_create( u_long __prog,  u_long __vers)
{
   OutFile << CurrentTime() << "myclntraw_create called " << endl;
   OutFile.flush();
   CLIENT * res = fptrclntraw_create(__prog, __vers);
   
   return res; 
}

void * mydlsym(void *__restrict __handle, __const char *__restrict __name)
{
   OutFile << CurrentTime() << "mydlsym called " << endl;
   OutFile.flush();
   void * res = fptrdlsym(__handle, __name);
   
   return res; 
}

size_t myfread(void *__restrict __ptr, size_t __size, size_t __n, FILE *__restrict __stream)
{
   OutFile << CurrentTime() << "myfread called " << endl;
   OutFile.flush();
   size_t res = fptrfread(__ptr, __size, __n, __stream);
   
   return res; 
}

int myaccept(int __fd, __SOCKADDR_ARG __addr, socklen_t *__restrict __addr_len)
{
   OutFile << CurrentTime() << "myaccept called " << endl;
   OutFile.flush();
   int res = fptraccept(__fd, __addr, __addr_len);
   
   return res; 
}

int mypselect(int __nfds, fd_set *__restrict __readfds, fd_set *__restrict __writefds, fd_set *__restrict __exceptfds, const struct timespec *__restrict __timeout, const __sigset_t *__restrict __sigmask)
{
   OutFile << CurrentTime() << "mypselect called " << endl;
   OutFile.flush();
   int res = fptrpselect(__nfds, __readfds, __writefds, __exceptfds, __timeout, __sigmask);
   
   return res; 
}

void myabort()
{
   OutFile << CurrentTime() << "myabort called " << endl;
   OutFile.flush();
   fptrabort();
   
}

int mypthread_cond_destroy(pthread_cond_t * __cond)
{
   OutFile << CurrentTime() << "mypthread_cond_destroy called " << endl;
   OutFile.flush();
   int res = fptrpthread_cond_destroy(__cond);
   
   return res; 
}

int mymvgetch(int y, int x)
{
   OutFile << CurrentTime() << "mymvgetch called " << endl;
   OutFile.flush();
   int res = fptrmvgetch(y, x);
   
   return res; 
}

int mypthread_spin_lock(pthread_spinlock_t * __lock)
{
   OutFile << CurrentTime() << "mypthread_spin_lock called " << endl;
   OutFile.flush();
   int res = fptrpthread_spin_lock(__lock);
   
   return res; 
}

wint_t mygetwc(__FILE * __stream)
{
   OutFile << CurrentTime() << "mygetwc called " << endl;
   OutFile.flush();
   wint_t res = fptrgetwc(__stream);
   
   return res; 
}

CLIENT * myclntudp_create(struct sockaddr_in * __raddr, u_long __program, u_long __version, struct timeval __wait_resend, int * __sockp)
{
   OutFile << CurrentTime() << "myclntudp_create called " << endl;
   OutFile.flush();
   CLIENT * res = fptrclntudp_create(__raddr, __program, __version, __wait_resend, __sockp);
   
   return res; 
}

ssize_t mywrite(int __fd, __const void * __buf, size_t __n)
{
   OutFile << CurrentTime() << "mywrite called " << endl;
   OutFile.flush();
   ssize_t res = fptrwrite(__fd, __buf, __n);
   
   return res; 
}

int mysigaction(int __sig, __const struct sigaction *__restrict __act, struct sigaction *__restrict __oact)
{
   OutFile << CurrentTime() << "mysigaction called " << endl;
   OutFile.flush();
   int res = fptrsigaction(__sig, __act, __oact);
   
   return res; 
}

void * mydlvsym(void *__restrict __handle, __const char *__restrict __name, __const char *__restrict __version)
{
   OutFile << CurrentTime() << "mydlvsym called " << endl;
   OutFile.flush();
   void * res = fptrdlvsym(__handle, __name, __version);
   
   return res; 
}

int mypthread_mutex_timedlock(pthread_mutex_t *__restrict __mutex, __const struct timespec *__restrict __abstime)
{
   OutFile << CurrentTime() << "mypthread_mutex_timedlock called " << endl;
   OutFile.flush();
   int res = fptrpthread_mutex_timedlock(__mutex, __abstime);
   
   return res; 
}

char * mygets(char * __s)
{
   OutFile << CurrentTime() << "mygets called " << endl;
   OutFile.flush();
   char * res = fptrgets(__s);
   
   return res; 
}

int mygetw(FILE * __stream)
{
   OutFile << CurrentTime() << "mygetw called " << endl;
   OutFile.flush();
   int res = fptrgetw(__stream);
   
   return res; 
}

int mypthread_barrier_init(pthread_barrier_t *__restrict __barrier, __const pthread_barrierattr_t *__restrict __attr, unsigned int __count)
{
   OutFile << CurrentTime() << "mypthread_barrier_init called " << endl;
   OutFile.flush();
   int res = fptrpthread_barrier_init(__barrier, __attr, __count);
   
   return res; 
}

int mysigsuspend(__const sigset_t * __set)
{
   OutFile << CurrentTime() << "mysigsuspend called " << endl;
   OutFile.flush();
   int res = fptrsigsuspend(__set);
   
   return res; 
}

bool_t mysvc_sendreply(SVCXPRT * xprt, xdrproc_t __xdr_results, caddr_t __xdr_location)
{
   OutFile << CurrentTime() << "mysvc_sendreply called " << endl;
   OutFile.flush();
   bool_t res = fptrsvc_sendreply(xprt, __xdr_results, __xdr_location);
   
   return res; 
}

int mypthread_spin_unlock(pthread_spinlock_t * __lock)
{
   OutFile << CurrentTime() << "mypthread_spin_unlock called " << endl;
   OutFile.flush();
   int res = fptrpthread_spin_unlock(__lock);
   
   return res; 
}

int mypthread_rwlock_rdlock(pthread_rwlock_t * __rwlock)
{
   OutFile << CurrentTime() << "mypthread_rwlock_rdlock called " << endl;
   OutFile.flush();
   int res = fptrpthread_rwlock_rdlock(__rwlock);
   
   return res; 
}

int mypthread_rwlock_wrlock(pthread_rwlock_t * __rwlock)
{
   OutFile << CurrentTime() << "mypthread_rwlock_wrlock called " << endl;
   OutFile.flush();
   int res = fptrpthread_rwlock_wrlock(__rwlock);
   
   return res; 
}

int mypthread_join(pthread_t __th, void** __thread_return)
{
   OutFile << CurrentTime() << "mypthread_join called " << endl;
   OutFile.flush();
   int res = fptrpthread_join(__th, __thread_return);
   
   return res; 
}

int mypthread_cond_init(pthread_cond_t *__restrict __cond, __const pthread_condattr_t *__restrict __cond_attr)
{
   OutFile << CurrentTime() << "mypthread_cond_init called " << endl;
   OutFile.flush();
   int res = fptrpthread_cond_init(__cond, __cond_attr);
   
   return res; 
}

void mysvc_run()
{
   OutFile << CurrentTime() << "mysvc_run called " << endl;
   OutFile.flush();
   fptrsvc_run();
   
}

int mysetitimer(__itimer_which_t __which, __const struct itimerval *__restrict __new, struct itimerval *__restrict __old)
{
   OutFile << CurrentTime() << "mysetitimer called " << endl;
   OutFile.flush();
   int res = fptrsetitimer(__which, __new, __old);
   
   return res; 
}

SVCXPRT * mysvcfd_create(int __svcfd_create_param1, u_int __svcfd_create_param2, u_int __svcfd_create_param_3)
{
   OutFile << CurrentTime() << "mysvcfd_create called " << endl;
   OutFile.flush();
   SVCXPRT * res = fptrsvcfd_create(__svcfd_create_param1, __svcfd_create_param2, __svcfd_create_param_3);
   
   return res; 
}

u_short mypmap_getport(struct sockaddr_in * __address,  u_long __program,  u_long __version, u_int __protocol)
{
   OutFile << CurrentTime() << "mypmap_getport called " << endl;
   OutFile.flush();
   u_short res = fptrpmap_getport(__address, __program, __version, __protocol);
   
   return res; 
}

int mypipe(int* __pipedes)
{
   OutFile << CurrentTime() << "mypipe called " << endl;
   OutFile.flush();
   int res = fptrpipe(__pipedes);
   
   return res; 
}

int mypthread_rwlock_timedwrlock(pthread_rwlock_t *__restrict __rwlock, __const struct timespec *__restrict __abstime)
{
   OutFile << CurrentTime() << "mypthread_rwlock_timedwrlock called " << endl;
   OutFile.flush();
   int res = fptrpthread_rwlock_timedwrlock(__rwlock, __abstime);
   
   return res; 
}





/* ===================================================================== */
/* Instrumnetation functions                                             */
/* ===================================================================== */

// Image load callback - inserts the probes.
void ImgLoad(IMG img, void *v)
{
    // Called every time a new image is loaded
    // Used to locate routines we want to probe

    if ( (IMG_Name(img).find("libc.so") != string::npos) ||
         (IMG_Name(img).find("LIBC.SO") != string::npos) ||
         (IMG_Name(img).find("LIBC.so") != string::npos) ) 
    {
        RTN rtnclnt_broadcast = RTN_FindByName(img, "clnt_broadcast");
        if (RTN_Valid(rtnclnt_broadcast) && RTN_IsSafeForProbedReplacement(rtnclnt_broadcast))
        {
            OutFile << CurrentTime() << "Inserting probe for clnt_broadcast at " << RTN_Address(rtnclnt_broadcast) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnclnt_broadcast, AFUNPTR(myclnt_broadcast)));
            fptrclnt_broadcast = (enum clnt_stat (*)( u_long ,  u_long ,  u_long , xdrproc_t , caddr_t , xdrproc_t , caddr_t , resultproc_t ))fptr;
        }
   
        RTN rtnregisterrpc = RTN_FindByName(img, "registerrpc");
        if (RTN_Valid(rtnregisterrpc) && RTN_IsSafeForProbedReplacement(rtnregisterrpc))
        {
            OutFile << CurrentTime() << "Inserting probe for registerrpc at " << RTN_Address(rtnregisterrpc) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnregisterrpc, AFUNPTR(myregisterrpc)));
            fptrregisterrpc = (int (*)(rpcprog_t , rpcvers_t , rpcproc_t , char *(*)(void *) , xdrproc_t , xdrproc_t ))fptr;
        }

        RTN rtnfclose = RTN_FindByName(img, "fclose");
        if (RTN_Valid(rtnfclose) && RTN_IsSafeForProbedReplacement(rtnfclose))
        {
            OutFile << CurrentTime() << "Inserting probe for fclose at " << RTN_Address(rtnfclose) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnfclose, AFUNPTR(myfclose)));
            fptrfclose = (int (*)(FILE * ))fptr;
        }

        RTN rtnsleep = RTN_FindByName(img, "sleep");
        if (RTN_Valid(rtnsleep) && RTN_IsSafeForProbedReplacement(rtnsleep))
        {
            OutFile << CurrentTime() << "Inserting probe for sleep at " << RTN_Address(rtnsleep) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnsleep, AFUNPTR(mysleep)));
            fptrsleep = (int (*)(unsigned int ))fptr;
        }

        RTN rtnfwrite = RTN_FindByName(img, "fwrite");
        if (RTN_Valid(rtnfwrite) && RTN_IsSafeForProbedReplacement(rtnfwrite))
        {
            OutFile << CurrentTime() << "Inserting probe for fwrite at " << RTN_Address(rtnfwrite) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnfwrite, AFUNPTR(myfwrite)));
            fptrfwrite = (size_t (*)(__const void *__restrict , size_t , size_t , FILE *__restrict ))fptr;
        }

        RTN rtnpmap_set = RTN_FindByName(img, "pmap_set");
        if (RTN_Valid(rtnpmap_set) && RTN_IsSafeForProbedReplacement(rtnpmap_set))
        {
            OutFile << CurrentTime() << "Inserting probe for pmap_set at " << RTN_Address(rtnpmap_set) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnpmap_set, AFUNPTR(mypmap_set)));
            fptrpmap_set = (bool_t (*)( u_long ,  u_long , int , u_short ))fptr;
        }

        RTN rtnsend = RTN_FindByName(img, "send");
        if (RTN_Valid(rtnsend) && RTN_IsSafeForProbedReplacement(rtnsend))
        {
            OutFile << CurrentTime() << "Inserting probe for send at " << RTN_Address(rtnsend) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnsend, AFUNPTR(mysend)));
            fptrsend = (ssize_t (*)(int , __const void * , size_t , int ))fptr;
        }
        
        RTN rtncallrpc = RTN_FindByName(img, "callrpc");
        if (RTN_Valid(rtncallrpc) && RTN_IsSafeForProbedReplacement(rtncallrpc))
        {
            OutFile << CurrentTime() << "Inserting probe for callrpc at " << RTN_Address(rtncallrpc) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtncallrpc, AFUNPTR(mycallrpc)));
            fptrcallrpc = (int (*)(__const char * ,  u_long ,  u_long ,  u_long ,  xdrproc_t , __const char * ,  xdrproc_t , char * ))fptr;
        }
        
        RTN rtnpmap_rmtcall = RTN_FindByName(img, "pmap_rmtcall");
        if (RTN_Valid(rtnpmap_rmtcall) && RTN_IsSafeForProbedReplacement(rtnpmap_rmtcall))
        {
            OutFile << CurrentTime() << "Inserting probe for pmap_rmtcall at " << RTN_Address(rtnpmap_rmtcall) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnpmap_rmtcall, AFUNPTR(mypmap_rmtcall)));
            fptrpmap_rmtcall = (enum clnt_stat (*)(struct sockaddr_in * ,  u_long ,  u_long ,  u_long , xdrproc_t , caddr_t , xdrproc_t , caddr_t , struct timeval , u_long * ))fptr;
        }
        
        RTN rtnsvctcp_create = RTN_FindByName(img, "svctcp_create");
        if (RTN_Valid(rtnsvctcp_create) && RTN_IsSafeForProbedReplacement(rtnsvctcp_create))
        {
            OutFile << CurrentTime() << "Inserting probe for svctcp_create at " << RTN_Address(rtnsvctcp_create) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnsvctcp_create, AFUNPTR(mysvctcp_create)));
            fptrsvctcp_create = (SVCXPRT * (*)(int , u_int , u_int ))fptr;
        }

        RTN rtnread = RTN_FindByName(img, "read");
        if (RTN_Valid(rtnread) && RTN_IsSafeForProbedReplacement(rtnread))
        {
            OutFile << CurrentTime() << "Inserting probe for read at " << RTN_Address(rtnread) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnread, AFUNPTR(myread)));
            fptrread = (ssize_t (*)(int , void * , size_t ))fptr;
        }
        
        RTN rtnsignal = RTN_FindByName(img, "signal");
        if (RTN_Valid(rtnsignal) && RTN_IsSafeForProbedReplacement(rtnsignal))
        {
            OutFile << CurrentTime() << "Inserting probe for signal at " << RTN_Address(rtnsignal) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnsignal, AFUNPTR(mysignal)));
            fptrsignal = (__sighandler_t (*)(int , __sighandler_t ))fptr;
        }
        
        RTN rtnfgetwc = RTN_FindByName(img, "fgetwc");
        if (RTN_Valid(rtnfgetwc) && RTN_IsSafeForProbedReplacement(rtnfgetwc))
        {
            OutFile << CurrentTime() << "Inserting probe for fgetwc at " << RTN_Address(rtnfgetwc) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnfgetwc, AFUNPTR(myfgetwc)));
            fptrfgetwc = (wint_t (*)(__FILE * ))fptr;
        }
        
        RTN rtnsendto = RTN_FindByName(img, "sendto");
        if (RTN_Valid(rtnsendto) && RTN_IsSafeForProbedReplacement(rtnsendto))
        {
            OutFile << CurrentTime() << "Inserting probe for sendto at " << RTN_Address(rtnsendto) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnsendto, AFUNPTR(mysendto)));
            fptrsendto = (ssize_t (*)(int , __const void * , size_t , int , __CONST_SOCKADDR_ARG , socklen_t ))fptr;
        }
        
        RTN rtnfgetws = RTN_FindByName(img, "fgetws");
        if (RTN_Valid(rtnfgetws) && RTN_IsSafeForProbedReplacement(rtnfgetws))
        {
            OutFile << CurrentTime() << "Inserting probe for fgetws at " << RTN_Address(rtnfgetws) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnfgetws, AFUNPTR(myfgetws)));
            fptrfgetws = (wchar_t * (*)(wchar_t *__restrict , int , __FILE *__restrict ))fptr;
        }
        
        RTN rtnfgetc = RTN_FindByName(img, "fgetc");
        if (RTN_Valid(rtnfgetc) && RTN_IsSafeForProbedReplacement(rtnfgetc))
        {
            OutFile << CurrentTime() << "Inserting probe for fgetc at " << RTN_Address(rtnfgetc) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnfgetc, AFUNPTR(myfgetc)));
            fptrfgetc = (void (*)(__FILE * ))fptr;
        }
        
        RTN rtnconnect = RTN_FindByName(img, "connect");
        if (RTN_Valid(rtnconnect) && RTN_IsSafeForProbedReplacement(rtnconnect))
        {
            OutFile << CurrentTime() << "Inserting probe for connect at " << RTN_Address(rtnconnect) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnconnect, AFUNPTR(myconnect)));
            fptrconnect = (int (*)(int , __CONST_SOCKADDR_ARG , socklen_t ))fptr;
        }
        
        RTN rtnfgets = RTN_FindByName(img, "fgets");
        if (RTN_Valid(rtnfgets) && RTN_IsSafeForProbedReplacement(rtnfgets))
        {
            OutFile << CurrentTime() << "Inserting probe for fgets at " << RTN_Address(rtnfgets) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnfgets, AFUNPTR(myfgets)));
            fptrfgets = (char * (*)(char *__restrict , int , FILE *__restrict ))fptr;
        }
        
        RTN rtnclose = RTN_FindByName(img, "close");
        if (RTN_Valid(rtnclose) && RTN_IsSafeForProbedReplacement(rtnclose))
        {
            OutFile << CurrentTime() << "Inserting probe for close at " << RTN_Address(rtnclose) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnclose, AFUNPTR(myclose)));
            fptrclose = (int (*)(int ))fptr;
        }
        
        RTN rtnrecvfrom = RTN_FindByName(img, "recvfrom");
        if (RTN_Valid(rtnrecvfrom) && RTN_IsSafeForProbedReplacement(rtnrecvfrom))
        {
            OutFile << CurrentTime() << "Inserting probe for recvfrom at " << RTN_Address(rtnrecvfrom) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnrecvfrom, AFUNPTR(myrecvfrom)));
            fptrrecvfrom = (ssize_t (*)(int , void *__restrict , size_t , int , __SOCKADDR_ARG , socklen_t *__restrict ))fptr;
        }
        
        RTN rtnfopen = RTN_FindByName(img, "fopen");
        if (RTN_Valid(rtnfopen) && RTN_IsSafeForProbedReplacement(rtnfopen))
        {
            OutFile << CurrentTime() << "Inserting probe for fopen at " << RTN_Address(rtnfopen) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnfopen, AFUNPTR(myfopen)));
            fptrfopen = (FILE * (*)(__const char *__restrict , __const char *__restrict ))fptr;
        }
        
        RTN rtnexit = RTN_FindByName(img, "exit");
        if (RTN_Valid(rtnexit) && RTN_IsSafeForProbedReplacement(rtnexit))
        {
            OutFile << CurrentTime() << "Inserting probe for exit at " << RTN_Address(rtnexit) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnexit, AFUNPTR(myexit)));
            fptrexit = (void (*)(int ))fptr;
        }
        
        RTN rtngetwchar = RTN_FindByName(img, "getwchar");
        if (RTN_Valid(rtngetwchar) && RTN_IsSafeForProbedReplacement(rtngetwchar))
        {
            OutFile << CurrentTime() << "Inserting probe for getwchar at " << RTN_Address(rtngetwchar) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtngetwchar, AFUNPTR(mygetwchar)));
            fptrgetwchar = (wint_t (*)())fptr;
        }
        
        RTN rtnrecv = RTN_FindByName(img, "recv");
        if (RTN_Valid(rtnrecv) && RTN_IsSafeForProbedReplacement(rtnrecv))
        {
            OutFile << CurrentTime() << "Inserting probe for recv at " << RTN_Address(rtnrecv) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnrecv, AFUNPTR(myrecv)));
            fptrrecv = (ssize_t (*)(int , void * , size_t , int ))fptr;
        }
        
        RTN rtnsocket = RTN_FindByName(img, "socket");
        if (RTN_Valid(rtnsocket) && RTN_IsSafeForProbedReplacement(rtnsocket))
        {
            OutFile << CurrentTime() << "Inserting probe for socket at " << RTN_Address(rtnsocket) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnsocket, AFUNPTR(mysocket)));
            fptrsocket = (int (*)(int , int , int ))fptr;
        }
        
        RTN rtnsvcraw_create = RTN_FindByName(img, "svcraw_create");
        if (RTN_Valid(rtnsvcraw_create) && RTN_IsSafeForProbedReplacement(rtnsvcraw_create))
        {
            OutFile << CurrentTime() << "Inserting probe for svcraw_create at " << RTN_Address(rtnsvcraw_create) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnsvcraw_create, AFUNPTR(mysvcraw_create)));
            fptrsvcraw_create = (SVCXPRT * (*)())fptr;
        }
        
        RTN rtnclntudp_bufcreate = RTN_FindByName(img, "clntudp_bufcreate");
        if (RTN_Valid(rtnclntudp_bufcreate) && RTN_IsSafeForProbedReplacement(rtnclntudp_bufcreate))
        {
            OutFile << CurrentTime() << "Inserting probe for clntudp_bufcreate at " << RTN_Address(rtnclntudp_bufcreate) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnclntudp_bufcreate, AFUNPTR(myclntudp_bufcreate)));
            fptrclntudp_bufcreate = (CLIENT * (*)(struct sockaddr_in * , u_long , u_long , struct timeval , int * , u_int , u_int ))fptr;
        }
        
        RTN rtn_exit = RTN_FindByName(img, "_exit");
        if (RTN_Valid(rtn_exit) && RTN_IsSafeForProbedReplacement(rtn_exit))
        {
            OutFile << CurrentTime() << "Inserting probe for _exit at " << RTN_Address(rtn_exit) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtn_exit, AFUNPTR(my_exit)));
            fptr_exit = (void (*)(int ))fptr;
        }
        
        RTN rtnvfork = RTN_FindByName(img, "vfork");
        if (RTN_Valid(rtnvfork) && RTN_IsSafeForProbedReplacement(rtnvfork))
        {
            OutFile << CurrentTime() << "Inserting probe for vfork at " << RTN_Address(rtnvfork) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnvfork, AFUNPTR(myvfork)));
            fptrvfork = (__pid_t (*)())fptr;
        }
        
        RTN rtnsvcudp_bufcreate = RTN_FindByName(img, "svcudp_bufcreate");
        if (RTN_Valid(rtnsvcudp_bufcreate) && 
            RTN_IsSafeForProbedReplacement(rtnsvcudp_bufcreate))
        {
            OutFile << CurrentTime() << "Inserting probe for svcudp_bufcreate at " << RTN_Address(rtnsvcudp_bufcreate) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnsvcudp_bufcreate, AFUNPTR(mysvcudp_bufcreate)));
            fptrsvcudp_bufcreate = (SVCXPRT * (*)(int , u_int , u_int ))fptr;
        }
        
        RTN rtnsvcudp_create = RTN_FindByName(img, "svcudp_create");
        if (RTN_Valid(rtnsvcudp_create) && 
            RTN_IsSafeForProbedReplacement(rtnsvcudp_create))
        {
            OutFile << CurrentTime() << "Inserting probe for svcudp_create at " << RTN_Address(rtnsvcudp_create) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnsvcudp_create, AFUNPTR(mysvcudp_create)));
            fptrsvcudp_create = (SVCXPRT * (*)(int ))fptr;
        }
        
        RTN rtnshutdown = RTN_FindByName(img, "shutdown");
        if (RTN_Valid(rtnshutdown) && RTN_IsSafeForProbedReplacement(rtnshutdown))
        {
            OutFile << CurrentTime() << "Inserting probe for shutdown at " << RTN_Address(rtnshutdown) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnshutdown, AFUNPTR(myshutdown)));
            fptrshutdown = (int (*)(int , int ))fptr;
        }
        
        RTN rtnpoll = RTN_FindByName(img, "poll");
        if (RTN_Valid(rtnpoll) && RTN_IsSafeForProbedReplacement(rtnpoll))
        {
            OutFile << CurrentTime() << "Inserting probe for poll at " << RTN_Address(rtnpoll) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnpoll, AFUNPTR(mypoll)));
            fptrpoll = (int (*)(struct pollfd * , nfds_t , int ))fptr;
        }
        
        RTN rtnopen = RTN_FindByName(img, "open");
        if (RTN_Valid(rtnopen) && RTN_IsSafeForProbedReplacement(rtnopen))
        {
            OutFile << CurrentTime() << "Inserting probe for open at " << RTN_Address(rtnopen) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnopen, AFUNPTR(myopen)));
            fptropen = (int (*)(__const char * , int , mode_t ))fptr;
        }
        
        RTN rtnselect = RTN_FindByName(img, "select");
        if (RTN_Valid(rtnselect) && RTN_IsSafeForProbedReplacement(rtnselect))
        {
            OutFile << CurrentTime() << "Inserting probe for select at " << RTN_Address(rtnselect) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnselect, AFUNPTR(myselect)));
            fptrselect = (int (*)(int , fd_set *__restrict , fd_set *__restrict , fd_set *__restrict , struct timeval *__restrict ))fptr;
        }
        
        RTN rtngetchar = RTN_FindByName(img, "getchar");
        if (RTN_Valid(rtngetchar) && RTN_IsSafeForProbedReplacement(rtngetchar))
        {
            OutFile << CurrentTime() << "Inserting probe for getchar at " << RTN_Address(rtngetchar) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtngetchar, AFUNPTR(mygetchar)));
            fptrgetchar = (int (*)())fptr;
        }
        
        RTN rtnsigprocmask = RTN_FindByName(img, "sigprocmask");
        if (RTN_Valid(rtnsigprocmask) && RTN_IsSafeForProbedReplacement(rtnsigprocmask))
        {
            OutFile << CurrentTime() << "Inserting probe for sigprocmask at " << RTN_Address(rtnsigprocmask) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnsigprocmask, AFUNPTR(mysigprocmask)));
            fptrsigprocmask = (int (*)(int , __const sigset_t *__restrict , sigset_t *__restrict ))fptr;
        }
        
        RTN rtnfdopen = RTN_FindByName(img, "fdopen");
        if (RTN_Valid(rtnfdopen) && RTN_IsSafeForProbedReplacement(rtnfdopen))
        {
            OutFile << CurrentTime() << "Inserting probe for fdopen at " << RTN_Address(rtnfdopen) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnfdopen, AFUNPTR(myfdopen)));
            fptrfdopen = (FILE * (*)(int , __const char * ))fptr;
        }
        
        RTN rtnsigpending = RTN_FindByName(img, "sigpending");
        if (RTN_Valid(rtnsigpending) && RTN_IsSafeForProbedReplacement(rtnsigpending))
        {
            OutFile << CurrentTime() << "Inserting probe for sigpending at " << RTN_Address(rtnsigpending) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnsigpending, AFUNPTR(mysigpending)));
            fptrsigpending = (int (*)(sigset_t * ))fptr;
        }
        
        RTN rtnfork = RTN_FindByName(img, "fork");
        if (RTN_Valid(rtnfork) && RTN_IsSafeForProbedReplacement(rtnfork))
        {
            OutFile << CurrentTime() << "Inserting probe for fork at " << RTN_Address(rtnfork) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnfork, AFUNPTR(myfork)));
            fptrfork = (__pid_t (*)())fptr;
        }
        
        RTN rtnexecve = RTN_FindByName(img, "execve");
        if (RTN_Valid(rtnexecve) && RTN_IsSafeForProbedReplacement(rtnexecve))
        {
            OutFile << CurrentTime() << "Inserting probe for execve at " << RTN_Address(rtnexecve) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnexecve, AFUNPTR(myexecve)));
            fptrexecve = (int (*)(__const char * , char *__const* , char *__const* ))fptr;
        }
        
        RTN rtn_IO_getc = RTN_FindByName(img, "_IO_getc");
        if (RTN_Valid(rtn_IO_getc) && RTN_IsSafeForProbedReplacement(rtn_IO_getc))
        {
            OutFile << CurrentTime() << "Inserting probe for _IO_getc at " << RTN_Address(rtn_IO_getc) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtn_IO_getc, AFUNPTR(my_IO_getc)));
            fptr_IO_getc = (int (*)(FILE * ))fptr;
        }
        
        RTN rtnpmap_getmaps = RTN_FindByName(img, "pmap_getmaps");
        if (RTN_Valid(rtnpmap_getmaps) && RTN_IsSafeForProbedReplacement(rtnpmap_getmaps))
        {
            OutFile << CurrentTime() << "Inserting probe for pmap_getmaps at " << RTN_Address(rtnpmap_getmaps) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnpmap_getmaps, AFUNPTR(mypmap_getmaps)));
            fptrpmap_getmaps = (struct pmaplist * (*)(struct sockaddr_in * ))fptr;
        }
        
        RTN rtnclntraw_create = RTN_FindByName(img, "clntraw_create");
        if (RTN_Valid(rtnclntraw_create) && RTN_IsSafeForProbedReplacement(rtnclntraw_create))
        {
            OutFile << CurrentTime() << "Inserting probe for clntraw_create at " << RTN_Address(rtnclntraw_create) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnclntraw_create, AFUNPTR(myclntraw_create)));
            fptrclntraw_create = (CLIENT * (*)( u_long ,  u_long ))fptr;
        }
        
        RTN rtnfread = RTN_FindByName(img, "fread");
        if (RTN_Valid(rtnfread) && RTN_IsSafeForProbedReplacement(rtnfread))
        {
            OutFile << CurrentTime() << "Inserting probe for fread at " << RTN_Address(rtnfread) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnfread, AFUNPTR(myfread)));
            fptrfread = (size_t (*)(void *__restrict , size_t , size_t , FILE *__restrict ))fptr;
        }
        
        RTN rtnaccept = RTN_FindByName(img, "accept");
        if (RTN_Valid(rtnaccept) && RTN_IsSafeForProbedReplacement(rtnaccept))
        {
            OutFile << CurrentTime() << "Inserting probe for accept at " << RTN_Address(rtnaccept) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnaccept, AFUNPTR(myaccept)));
            fptraccept = (int (*)(int , __SOCKADDR_ARG , socklen_t *__restrict ))fptr;
        }
        
        RTN rtnpselect = RTN_FindByName(img, "pselect");
        if (RTN_Valid(rtnpselect) && RTN_IsSafeForProbedReplacement(rtnpselect))
        {
            OutFile << CurrentTime() << "Inserting probe for pselect at " << RTN_Address(rtnpselect) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnpselect, AFUNPTR(mypselect)));
            fptrpselect = (int (*)(int , fd_set *__restrict , fd_set *__restrict , fd_set *__restrict , const struct timespec *__restrict , const __sigset_t *__restrict ))fptr;
        }
        
        RTN rtnabort = RTN_FindByName(img, "abort");
        if (RTN_Valid(rtnabort) && RTN_IsSafeForProbedReplacement(rtnabort))
        {
            OutFile << CurrentTime() << "Inserting probe for abort at " << RTN_Address(rtnabort) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnabort, AFUNPTR(myabort)));
            fptrabort = (void (*)())fptr;
        }
        
        RTN rtngetwc = RTN_FindByName(img, "getwc");
        if (RTN_Valid(rtngetwc) && RTN_IsSafeForProbedReplacement(rtngetwc))
        {
            OutFile << CurrentTime() << "Inserting probe for getwc at " << RTN_Address(rtngetwc) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtngetwc, AFUNPTR(mygetwc)));
            fptrgetwc = (wint_t (*)(__FILE * ))fptr;
        }
        
        RTN rtnclntudp_create = RTN_FindByName(img, "clntudp_create");
        if (RTN_Valid(rtnclntudp_create) && RTN_IsSafeForProbedReplacement(rtnclntudp_create))
        {
            OutFile << CurrentTime() << "Inserting probe for clntudp_create at " << RTN_Address(rtnclntudp_create) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnclntudp_create, AFUNPTR(myclntudp_create)));
            fptrclntudp_create = (CLIENT * (*)(struct sockaddr_in * , u_long , u_long , struct timeval , int * ))fptr;
        }
        
        RTN rtnwrite = RTN_FindByName(img, "write");
        if (RTN_Valid(rtnwrite) && RTN_IsSafeForProbedReplacement(rtnwrite))
        {
            OutFile << CurrentTime() << "Inserting probe for write at " << RTN_Address(rtnwrite) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnwrite, AFUNPTR(mywrite)));
            fptrwrite = (ssize_t (*)(int , __const void * , size_t ))fptr;
        }
        
        RTN rtnsigaction = RTN_FindByName(img, "sigaction");
        if (RTN_Valid(rtnsigaction) && RTN_IsSafeForProbedReplacement(rtnsigaction))
        {
            OutFile << CurrentTime() << "Inserting probe for sigaction at " << RTN_Address(rtnsigaction) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnsigaction, AFUNPTR(mysigaction)));
            fptrsigaction = (int (*)(int , __const struct sigaction *__restrict , struct sigaction *__restrict ))fptr;
        }
        
        RTN rtngets = RTN_FindByName(img, "gets");
        if (RTN_Valid(rtngets) && RTN_IsSafeForProbedReplacement(rtngets))
        {
            OutFile << CurrentTime() << "Inserting probe for gets at " << RTN_Address(rtngets) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtngets, AFUNPTR(mygets)));
            fptrgets = (char * (*)(char * ))fptr;
        }
        
        RTN rtngetw = RTN_FindByName(img, "getw");
        if (RTN_Valid(rtngetw) && RTN_IsSafeForProbedReplacement(rtngetw))
        {
            OutFile << CurrentTime() << "Inserting probe for getw at " << RTN_Address(rtngetw) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtngetw, AFUNPTR(mygetw)));
            fptrgetw = (int (*)(FILE * ))fptr;
        }
        
        RTN rtnsigsuspend = RTN_FindByName(img, "sigsuspend");
        if (RTN_Valid(rtnsigsuspend) && RTN_IsSafeForProbedReplacement(rtnsigsuspend))
        {
            OutFile << CurrentTime() << "Inserting probe for sigsuspend at " << RTN_Address(rtnsigsuspend) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnsigsuspend, AFUNPTR(mysigsuspend)));
            fptrsigsuspend = (int (*)(__const sigset_t * ))fptr;
        }
        
        RTN rtnsvc_sendreply = RTN_FindByName(img, "svc_sendreply");
        if (RTN_Valid(rtnsvc_sendreply) && RTN_IsSafeForProbedReplacement(rtnsvc_sendreply))
        {
            OutFile << CurrentTime() << "Inserting probe for svc_sendreply at " << RTN_Address(rtnsvc_sendreply) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnsvc_sendreply, AFUNPTR(mysvc_sendreply)));
            fptrsvc_sendreply = (bool_t (*)(SVCXPRT * , xdrproc_t , caddr_t ))fptr;
        }
        
        RTN rtnsvc_run = RTN_FindByName(img, "svc_run");
        if (RTN_Valid(rtnsvc_run) && RTN_IsSafeForProbedReplacement(rtnsvc_run))
        {
            OutFile << CurrentTime() << "Inserting probe for svc_run at " << RTN_Address(rtnsvc_run) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnsvc_run, AFUNPTR(mysvc_run)));
            fptrsvc_run = (void (*)())fptr;
        }
        
        RTN rtnsetitimer = RTN_FindByName(img, "setitimer");
        if (RTN_Valid(rtnsetitimer) && RTN_IsSafeForProbedReplacement(rtnsetitimer))
        {
            OutFile << CurrentTime() << "Inserting probe for setitimer at " << RTN_Address(rtnsetitimer) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnsetitimer, AFUNPTR(mysetitimer)));
            fptrsetitimer = (int (*)(__itimer_which_t , __const struct itimerval *__restrict , struct itimerval *__restrict ))fptr;
        }
        
        RTN rtnsvcfd_create = RTN_FindByName(img, "svcfd_create");
        if (RTN_Valid(rtnsvcfd_create) && RTN_IsSafeForProbedReplacement(rtnsvcfd_create))
        {
            OutFile << CurrentTime() << "Inserting probe for svcfd_create at " << RTN_Address(rtnsvcfd_create) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnsvcfd_create, AFUNPTR(mysvcfd_create)));
            fptrsvcfd_create = (SVCXPRT * (*)(int , u_int , u_int ))fptr;
        }
        
        RTN rtnpmap_getport = RTN_FindByName(img, "pmap_getport");
        if (RTN_Valid(rtnpmap_getport) && RTN_IsSafeForProbedReplacement(rtnpmap_getport))
        {
            OutFile << CurrentTime() << "Inserting probe for pmap_getport at " << RTN_Address(rtnpmap_getport) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnpmap_getport, AFUNPTR(mypmap_getport)));
            fptrpmap_getport = (u_short (*)(struct sockaddr_in * ,  u_long ,  u_long , u_int ))fptr;
        }
        
        RTN rtnpipe = RTN_FindByName(img, "pipe");
        if (RTN_Valid(rtnpipe) && RTN_IsSafeForProbedReplacement(rtnpipe))
        {
            OutFile << CurrentTime() << "Inserting probe for pipe at " << RTN_Address(rtnpipe) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnpipe, AFUNPTR(mypipe)));
            fptrpipe = (int (*)(int[2] ))fptr;
        }
        
    } // libc.so

    if ( (IMG_Name(img).find("libpthread.so") != string::npos) ||
         (IMG_Name(img).find("LIBPTHREAD.SO") != string::npos) ||
         (IMG_Name(img).find("LIBPTHREAD.so") != string::npos) ) 
    {
        RTN rtnsem_wait = RTN_FindByName(img, "sem_wait");
        if (RTN_Valid(rtnsem_wait) && RTN_IsSafeForProbedReplacement(rtnsem_wait))
        {
            OutFile << CurrentTime() << "Inserting probe for sem_wait at " << RTN_Address(rtnsem_wait) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnsem_wait, AFUNPTR(mysem_wait)));
            fptrsem_wait = (int (*)(sem_t * ))fptr;
        }
     
        RTN rtnpthread_barrier_destroy = RTN_FindByName(img, "pthread_barrier_destroy");
        if (RTN_Valid(rtnpthread_barrier_destroy) && RTN_IsSafeForProbedReplacement(rtnpthread_barrier_destroy))
        {
            OutFile << CurrentTime() << "Inserting probe for pthread_barrier_destroy at " << RTN_Address(rtnpthread_barrier_destroy) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnpthread_barrier_destroy, AFUNPTR(mypthread_barrier_destroy)));
            fptrpthread_barrier_destroy = (int (*)(pthread_barrier_t * ))fptr;
        }
        
        RTN rtnsem_destroy = RTN_FindByName(img, "sem_destroy");
        if (RTN_Valid(rtnsem_destroy) && RTN_IsSafeForProbedReplacement(rtnsem_destroy))
        {
            OutFile << CurrentTime() << "Inserting probe for sem_destroy at " << RTN_Address(rtnsem_destroy) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnsem_destroy, AFUNPTR(mysem_destroy)));
            fptrsem_destroy = (int (*)(sem_t * ))fptr;
        }
        
        RTN rtnpthread_mutex_init = RTN_FindByName(img, "pthread_mutex_init");
        if (RTN_Valid(rtnpthread_mutex_init) && RTN_IsSafeForProbedReplacement(rtnpthread_mutex_init))
        {
            OutFile << CurrentTime() << "Inserting probe for pthread_mutex_init at " << RTN_Address(rtnpthread_mutex_init) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnpthread_mutex_init, AFUNPTR(mypthread_mutex_init)));
            fptrpthread_mutex_init = (int (*)(pthread_mutex_t * , __const pthread_mutexattr_t * ))fptr;
        }
        
        RTN rtnsem_init = RTN_FindByName(img, "sem_init");
        if (RTN_Valid(rtnsem_init) && RTN_IsSafeForProbedReplacement(rtnsem_init))
        {
            OutFile << CurrentTime() << "Inserting probe for sem_init at " << RTN_Address(rtnsem_init) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnsem_init, AFUNPTR(mysem_init)));
            fptrsem_init = (int (*)(sem_t * , int , unsigned int ))fptr;
        }

        RTN rtnpthread_mutex_lock = RTN_FindByName(img, "pthread_mutex_lock");
        if (RTN_Valid(rtnpthread_mutex_lock) && RTN_IsSafeForProbedReplacement(rtnpthread_mutex_lock))
        {
            OutFile << CurrentTime() << "Inserting probe for pthread_mutex_lock at " << RTN_Address(rtnpthread_mutex_lock) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnpthread_mutex_lock, AFUNPTR(mypthread_mutex_lock)));
            fptrpthread_mutex_lock = (int (*)(pthread_mutex_t * ))fptr;
        }
        
        RTN rtnpthread_cancel = RTN_FindByName(img, "pthread_cancel");
        if (RTN_Valid(rtnpthread_cancel) && RTN_IsSafeForProbedReplacement(rtnpthread_cancel))
        {
            OutFile << CurrentTime() << "Inserting probe for pthread_cancel at " << RTN_Address(rtnpthread_cancel) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnpthread_cancel, AFUNPTR(mypthread_cancel)));
            fptrpthread_cancel = (int (*)(pthread_t ))fptr;
        }
        
        RTN rtnpthread_cond_wait = RTN_FindByName(img, "pthread_cond_wait");
        if (RTN_Valid(rtnpthread_cond_wait) && RTN_IsSafeForProbedReplacement(rtnpthread_cond_wait))
        {
            OutFile << CurrentTime() << "Inserting probe for pthread_cond_wait at " << RTN_Address(rtnpthread_cond_wait) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnpthread_cond_wait, AFUNPTR(mypthread_cond_wait)));
            fptrpthread_cond_wait = (int (*)(pthread_cond_t *__restrict , pthread_mutex_t *__restrict ))fptr;
        }
        
        RTN rtnpthread_cond_signal = RTN_FindByName(img, "pthread_cond_signal");
        if (RTN_Valid(rtnpthread_cond_signal) && RTN_IsSafeForProbedReplacement(rtnpthread_cond_signal))
        {
            OutFile << CurrentTime() << "Inserting probe for pthread_cond_signal at " << RTN_Address(rtnpthread_cond_signal) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnpthread_cond_signal, AFUNPTR(mypthread_cond_signal)));
            fptrpthread_cond_signal = (int (*)(pthread_cond_t * ))fptr;
        }
        
        RTN rtnpthread_barrier_wait = RTN_FindByName(img, "pthread_barrier_wait");
        if (RTN_Valid(rtnpthread_barrier_wait) && RTN_IsSafeForProbedReplacement(rtnpthread_barrier_wait))
        {
            OutFile << CurrentTime() << "Inserting probe for pthread_barrier_wait at " << RTN_Address(rtnpthread_barrier_wait) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnpthread_barrier_wait, AFUNPTR(mypthread_barrier_wait)));
            fptrpthread_barrier_wait = (int (*)(pthread_barrier_t * ))fptr;
        }
        
        RTN rtnpthread_spin_destroy = RTN_FindByName(img, "pthread_spin_destroy");
        if (RTN_Valid(rtnpthread_spin_destroy) && RTN_IsSafeForProbedReplacement(rtnpthread_spin_destroy))
        {
            OutFile << CurrentTime() << "Inserting probe for pthread_spin_destroy at " << RTN_Address(rtnpthread_spin_destroy) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnpthread_spin_destroy, AFUNPTR(mypthread_spin_destroy)));
            fptrpthread_spin_destroy = (int (*)(pthread_spinlock_t * ))fptr;
        }
        
        RTN rtnpthread_key_delete = RTN_FindByName(img, "pthread_key_delete");
        if (RTN_Valid(rtnpthread_key_delete) && RTN_IsSafeForProbedReplacement(rtnpthread_key_delete))
        {
            OutFile << CurrentTime() << "Inserting probe for pthread_key_delete at " << RTN_Address(rtnpthread_key_delete) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnpthread_key_delete, AFUNPTR(mypthread_key_delete)));
            fptrpthread_key_delete = (int (*)(pthread_key_t ))fptr;
        }
        
        RTN rtnpthread_setspecific = RTN_FindByName(img, "pthread_setspecific");
        if (RTN_Valid(rtnpthread_setspecific) && RTN_IsSafeForProbedReplacement(rtnpthread_setspecific))
        {
            OutFile << CurrentTime() << "Inserting probe for pthread_setspecific at " << RTN_Address(rtnpthread_setspecific) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnpthread_setspecific, AFUNPTR(mypthread_setspecific)));
            fptrpthread_setspecific = (int (*)(pthread_key_t , __const void * ))fptr;
        }
        
        RTN rtnpthread_rwlock_timedrdlock = RTN_FindByName(img, "pthread_rwlock_timedrdlock");
        if (RTN_Valid(rtnpthread_rwlock_timedrdlock) && RTN_IsSafeForProbedReplacement(rtnpthread_rwlock_timedrdlock))
        {
            OutFile << CurrentTime() << "Inserting probe for pthread_rwlock_timedrdlock at " << RTN_Address(rtnpthread_rwlock_timedrdlock) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnpthread_rwlock_timedrdlock, AFUNPTR(mypthread_rwlock_timedrdlock)));
            fptrpthread_rwlock_timedrdlock = (int (*)(pthread_rwlock_t *__restrict , __const struct timespec *__restrict ))fptr;
        }
        
        RTN rtnpthread_rwlock_destroy = RTN_FindByName(img, "pthread_rwlock_destroy");
        if (RTN_Valid(rtnpthread_rwlock_destroy) && RTN_IsSafeForProbedReplacement(rtnpthread_rwlock_destroy))
        {
            OutFile << CurrentTime() << "Inserting probe for pthread_rwlock_destroy at " << RTN_Address(rtnpthread_rwlock_destroy) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnpthread_rwlock_destroy, AFUNPTR(mypthread_rwlock_destroy)));
            fptrpthread_rwlock_destroy = (int (*)(pthread_rwlock_t * ))fptr;
        }
        
        RTN rtnpthread_exit = RTN_FindByName(img, "pthread_exit");
        if (RTN_Valid(rtnpthread_exit) && RTN_IsSafeForProbedReplacement(rtnpthread_exit))
        {
            OutFile << CurrentTime() << "Inserting probe for pthread_exit at " << RTN_Address(rtnpthread_exit) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnpthread_exit, AFUNPTR(mypthread_exit)));
            fptrpthread_exit = (void (*)(void* ))fptr;
        }
        
        RTN rtnsem_post = RTN_FindByName(img, "sem_post");
        if (RTN_Valid(rtnsem_post) && RTN_IsSafeForProbedReplacement(rtnsem_post))
        {
            OutFile << CurrentTime() << "Inserting probe for sem_post at " << RTN_Address(rtnsem_post) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnsem_post, AFUNPTR(mysem_post)));
            fptrsem_post = (int (*)(sem_t * ))fptr;
        }
        
        RTN rtnpthread_create = RTN_FindByName(img, "pthread_create");
        if (RTN_Valid(rtnpthread_create) && RTN_IsSafeForProbedReplacement(rtnpthread_create))
        {
            OutFile << CurrentTime() << "Inserting probe for pthread_create at " << RTN_Address(rtnpthread_create) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnpthread_create, AFUNPTR(mypthread_create)));
            fptrpthread_create = (int (*)(pthread_t *__restrict , __const pthread_attr_t *__restrict , void *(*)(void *) , void *__restrict ))fptr;
        }
        
        RTN rtnpthread_spin_init = RTN_FindByName(img, "pthread_spin_init");
        if (RTN_Valid(rtnpthread_spin_init) && RTN_IsSafeForProbedReplacement(rtnpthread_spin_init))
        {
            OutFile << CurrentTime() << "Inserting probe for pthread_spin_init at " << RTN_Address(rtnpthread_spin_init) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnpthread_spin_init, AFUNPTR(mypthread_spin_init)));
            fptrpthread_spin_init = (int (*)(pthread_spinlock_t * , int ))fptr;
        }
        
        RTN rtnpthread_key_create = RTN_FindByName(img, "pthread_key_create");
        if (RTN_Valid(rtnpthread_key_create) && RTN_IsSafeForProbedReplacement(rtnpthread_key_create))
        {
            OutFile << CurrentTime() << "Inserting probe for pthread_key_create at " << RTN_Address(rtnpthread_key_create) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnpthread_key_create, AFUNPTR(mypthread_key_create)));
            fptrpthread_key_create = (int (*)(pthread_key_t * , void (*) (void *) ))fptr;
        }
        
        RTN rtnnanosleep = RTN_FindByName(img, "nanosleep");
        if (RTN_Valid(rtnnanosleep) && RTN_IsSafeForProbedReplacement(rtnnanosleep))
        {
            OutFile << CurrentTime() << "Inserting probe for nanosleep at " << RTN_Address(rtnnanosleep) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnnanosleep, AFUNPTR(mynanosleep)));
            fptrnanosleep = (int (*)(__const struct timespec * , struct timespec * ))fptr;
        }
        
        RTN rtnpthread_cond_timedwait = RTN_FindByName(img, "pthread_cond_timedwait");
        if (RTN_Valid(rtnpthread_cond_timedwait) && RTN_IsSafeForProbedReplacement(rtnpthread_cond_timedwait))
        {
            OutFile << CurrentTime() << "Inserting probe for pthread_cond_timedwait at " << RTN_Address(rtnpthread_cond_timedwait) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnpthread_cond_timedwait, AFUNPTR(mypthread_cond_timedwait)));
            fptrpthread_cond_timedwait = (int (*)(pthread_cond_t *__restrict , pthread_mutex_t *__restrict , __const struct timespec *__restrict ))fptr;
        }
        
        RTN rtnpthread_cond_broadcast = RTN_FindByName(img, "pthread_cond_broadcast");
        if (RTN_Valid(rtnpthread_cond_broadcast) && RTN_IsSafeForProbedReplacement(rtnpthread_cond_broadcast))
        {
            OutFile << CurrentTime() << "Inserting probe for pthread_cond_broadcast at " << RTN_Address(rtnpthread_cond_broadcast) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnpthread_cond_broadcast, AFUNPTR(mypthread_cond_broadcast)));
            fptrpthread_cond_broadcast = (int (*)(pthread_cond_t * ))fptr;
        }
        
        RTN rtnpthread_mutex_unlock = RTN_FindByName(img, "pthread_mutex_unlock");
        if (RTN_Valid(rtnpthread_mutex_unlock) && RTN_IsSafeForProbedReplacement(rtnpthread_mutex_unlock))
        {
            OutFile << CurrentTime() << "Inserting probe for pthread_mutex_unlock at " << RTN_Address(rtnpthread_mutex_unlock) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnpthread_mutex_unlock, AFUNPTR(mypthread_mutex_unlock)));
            fptrpthread_mutex_unlock = (int (*)(pthread_mutex_t * ))fptr;
        }
        
        RTN rtnpthread_sigmask = RTN_FindByName(img, "pthread_sigmask");
        if (RTN_Valid(rtnpthread_sigmask) && RTN_IsSafeForProbedReplacement(rtnpthread_sigmask))
        {
            OutFile << CurrentTime() << "Inserting probe for pthread_sigmask at " << RTN_Address(rtnpthread_sigmask) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnpthread_sigmask, AFUNPTR(mypthread_sigmask)));
            fptrpthread_sigmask = (int (*)(int , __const sigset_t *__restrict , sigset_t *__restrict ))fptr;
        }
        
        RTN rtnpthread_mutex_destroy = RTN_FindByName(img, "pthread_mutex_destroy");
        if (RTN_Valid(rtnpthread_mutex_destroy) && RTN_IsSafeForProbedReplacement(rtnpthread_mutex_destroy))
        {
            OutFile << CurrentTime() << "Inserting probe for pthread_mutex_destroy at " << RTN_Address(rtnpthread_mutex_destroy) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnpthread_mutex_destroy, AFUNPTR(mypthread_mutex_destroy)));
            fptrpthread_mutex_destroy = (int (*)(pthread_mutex_t * ))fptr;
        }
        
        RTN rtnpthread_rwlock_init = RTN_FindByName(img, "pthread_rwlock_init");
        if (RTN_Valid(rtnpthread_rwlock_init) && RTN_IsSafeForProbedReplacement(rtnpthread_rwlock_init))
        {
            OutFile << CurrentTime() << "Inserting probe for pthread_rwlock_init at " << RTN_Address(rtnpthread_rwlock_init) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnpthread_rwlock_init, AFUNPTR(mypthread_rwlock_init)));
            fptrpthread_rwlock_init = (int (*)(pthread_rwlock_t *__restrict , __const pthread_rwlockattr_t *__restrict ))fptr;
        }
        
        RTN rtnpthread_rwlock_unlock = RTN_FindByName(img, "pthread_rwlock_unlock");
        if (RTN_Valid(rtnpthread_rwlock_unlock) && RTN_IsSafeForProbedReplacement(rtnpthread_rwlock_unlock))
        {
            OutFile << CurrentTime() << "Inserting probe for pthread_rwlock_unlock at " << RTN_Address(rtnpthread_rwlock_unlock) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnpthread_rwlock_unlock, AFUNPTR(mypthread_rwlock_unlock)));
            fptrpthread_rwlock_unlock = (int (*)(pthread_rwlock_t * ))fptr;
        }
        
        RTN rtnpthread_cond_destroy = RTN_FindByName(img, "pthread_cond_destroy");
        if (RTN_Valid(rtnpthread_cond_destroy) && RTN_IsSafeForProbedReplacement(rtnpthread_cond_destroy))
        {
            OutFile << CurrentTime() << "Inserting probe for pthread_cond_destroy at " << RTN_Address(rtnpthread_cond_destroy) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnpthread_cond_destroy, AFUNPTR(mypthread_cond_destroy)));
            fptrpthread_cond_destroy = (int (*)(pthread_cond_t * ))fptr;
        }
        
        RTN rtnpthread_spin_lock = RTN_FindByName(img, "pthread_spin_lock");
        if (RTN_Valid(rtnpthread_spin_lock) && RTN_IsSafeForProbedReplacement(rtnpthread_spin_lock))
        {
            OutFile << CurrentTime() << "Inserting probe for pthread_spin_lock at " << RTN_Address(rtnpthread_spin_lock) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnpthread_spin_lock, AFUNPTR(mypthread_spin_lock)));
            fptrpthread_spin_lock = (int (*)(pthread_spinlock_t * ))fptr;
        }
        
        RTN rtnpthread_mutex_timedlock = RTN_FindByName(img, "pthread_mutex_timedlock");
        if (RTN_Valid(rtnpthread_mutex_timedlock) && RTN_IsSafeForProbedReplacement(rtnpthread_mutex_timedlock))
        {
            OutFile << CurrentTime() << "Inserting probe for pthread_mutex_timedlock at " << RTN_Address(rtnpthread_mutex_timedlock) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnpthread_mutex_timedlock, AFUNPTR(mypthread_mutex_timedlock)));
            fptrpthread_mutex_timedlock = (int (*)(pthread_mutex_t *__restrict , __const struct timespec *__restrict ))fptr;
        }
        
        RTN rtnpthread_barrier_init = RTN_FindByName(img, "pthread_barrier_init");
        if (RTN_Valid(rtnpthread_barrier_init) && RTN_IsSafeForProbedReplacement(rtnpthread_barrier_init))
        {
            OutFile << CurrentTime() << "Inserting probe for pthread_barrier_init at " << RTN_Address(rtnpthread_barrier_init) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnpthread_barrier_init, AFUNPTR(mypthread_barrier_init)));
            fptrpthread_barrier_init = (int (*)(pthread_barrier_t *__restrict , __const pthread_barrierattr_t *__restrict , unsigned int ))fptr;
        }
        
        RTN rtnpthread_spin_unlock = RTN_FindByName(img, "pthread_spin_unlock");
        if (RTN_Valid(rtnpthread_spin_unlock) && RTN_IsSafeForProbedReplacement(rtnpthread_spin_unlock))
        {
            OutFile << CurrentTime() << "Inserting probe for pthread_spin_unlock at " << RTN_Address(rtnpthread_spin_unlock) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnpthread_spin_unlock, AFUNPTR(mypthread_spin_unlock)));
            fptrpthread_spin_unlock = (int (*)(pthread_spinlock_t * ))fptr;
        }
        
        RTN rtnpthread_rwlock_rdlock = RTN_FindByName(img, "pthread_rwlock_rdlock");
        if (RTN_Valid(rtnpthread_rwlock_rdlock) && RTN_IsSafeForProbedReplacement(rtnpthread_rwlock_rdlock))
        {
            OutFile << CurrentTime() << "Inserting probe for pthread_rwlock_rdlock at " << RTN_Address(rtnpthread_rwlock_rdlock) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnpthread_rwlock_rdlock, AFUNPTR(mypthread_rwlock_rdlock)));
            fptrpthread_rwlock_rdlock = (int (*)(pthread_rwlock_t * ))fptr;
        }
        
        RTN rtnpthread_rwlock_wrlock = RTN_FindByName(img, "pthread_rwlock_wrlock");
        if (RTN_Valid(rtnpthread_rwlock_wrlock) && RTN_IsSafeForProbedReplacement(rtnpthread_rwlock_wrlock))
        {
            OutFile << CurrentTime() << "Inserting probe for pthread_rwlock_wrlock at " << RTN_Address(rtnpthread_rwlock_wrlock) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnpthread_rwlock_wrlock, AFUNPTR(mypthread_rwlock_wrlock)));
            fptrpthread_rwlock_wrlock = (int (*)(pthread_rwlock_t * ))fptr;
        }
        
        RTN rtnpthread_join = RTN_FindByName(img, "pthread_join");
        if (RTN_Valid(rtnpthread_join) && RTN_IsSafeForProbedReplacement(rtnpthread_join))
        {
            OutFile << CurrentTime() << "Inserting probe for pthread_join at " << RTN_Address(rtnpthread_join) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnpthread_join, AFUNPTR(mypthread_join)));
            fptrpthread_join = (int (*)(pthread_t , void** ))fptr;
        }
        
        RTN rtnpthread_cond_init = RTN_FindByName(img, "pthread_cond_init");
        if (RTN_Valid(rtnpthread_cond_init) && RTN_IsSafeForProbedReplacement(rtnpthread_cond_init))
        {
            OutFile << CurrentTime() << "Inserting probe for pthread_cond_init at " << RTN_Address(rtnpthread_cond_init) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnpthread_cond_init, AFUNPTR(mypthread_cond_init)));
            fptrpthread_cond_init = (int (*)(pthread_cond_t *__restrict , __const pthread_condattr_t *__restrict ))fptr;
        }
        
        RTN rtnpthread_rwlock_timedwrlock = RTN_FindByName(img, "pthread_rwlock_timedwrlock");
        if (RTN_Valid(rtnpthread_rwlock_timedwrlock) && RTN_IsSafeForProbedReplacement(rtnpthread_rwlock_timedwrlock))
        {
            OutFile << CurrentTime() << "Inserting probe for pthread_rwlock_timedwrlock at " << RTN_Address(rtnpthread_rwlock_timedwrlock) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnpthread_rwlock_timedwrlock, AFUNPTR(mypthread_rwlock_timedwrlock)));
            fptrpthread_rwlock_timedwrlock = (int (*)(pthread_rwlock_t *__restrict , __const struct timespec *__restrict ))fptr;
        }
        
    } // libpthread.so

    if ( (IMG_Name(img).find("libdl.so") != string::npos) ||
         (IMG_Name(img).find("LIBDL.SO") != string::npos) ||
         (IMG_Name(img).find("LIBDL.so") != string::npos) ) 
    {
    
        RTN rtndladdr1 = RTN_FindByName(img, "dladdr1");
        if (RTN_Valid(rtndladdr1) && RTN_IsSafeForProbedReplacement(rtndladdr1))
        {
            OutFile << CurrentTime() << "Inserting probe for dladdr1 at " << RTN_Address(rtndladdr1) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtndladdr1, AFUNPTR(mydladdr1)));
            fptrdladdr1 = (int (*)(__const void * , Dl_info * , void ** , int ))fptr;
        }
        
        RTN rtndlclose = RTN_FindByName(img, "dlclose");
        if (RTN_Valid(rtndlclose) && RTN_IsSafeForProbedReplacement(rtndlclose))
        {
            OutFile << CurrentTime() << "Inserting probe for dlclose at " << RTN_Address(rtndlclose) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtndlclose, AFUNPTR(mydlclose)));
            fptrdlclose = (int (*)(void * ))fptr;
        }
        
        RTN rtndlopen = RTN_FindByName(img, "dlopen");
        if (RTN_Valid(rtndlopen) && RTN_IsSafeForProbedReplacement(rtndlopen))
        {
            OutFile << CurrentTime() << "Inserting probe for dlopen at " << RTN_Address(rtndlopen) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtndlopen, AFUNPTR(mydlopen)));
            fptrdlopen = (void * (*)(__const char * , int ))fptr;
        }
        
        RTN rtndladdr = RTN_FindByName(img, "dladdr");
        if (RTN_Valid(rtndladdr) && RTN_IsSafeForProbedReplacement(rtndladdr))
        {
            OutFile << CurrentTime() << "Inserting probe for dladdr at " << RTN_Address(rtndladdr) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtndladdr, AFUNPTR(mydladdr)));
            fptrdladdr = (int (*)(__const void * , Dl_info * ))fptr;
        }
        
        RTN rtndlsym = RTN_FindByName(img, "dlsym");
        if (RTN_Valid(rtndlsym) && RTN_IsSafeForProbedReplacement(rtndlsym))
        {
            OutFile << CurrentTime() << "Inserting probe for dlsym at " << RTN_Address(rtndlsym) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtndlsym, AFUNPTR(mydlsym)));
            fptrdlsym = (void * (*)(void *__restrict , __const char *__restrict ))fptr;
        }
        
        RTN rtndlvsym = RTN_FindByName(img, "dlvsym");
        if (RTN_Valid(rtndlvsym) && RTN_IsSafeForProbedReplacement(rtndlvsym))
        {
            OutFile << CurrentTime() << "Inserting probe for dlvsym at " << RTN_Address(rtndlvsym) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtndlvsym, AFUNPTR(mydlvsym)));
            fptrdlvsym = (void * (*)(void *__restrict , __const char *__restrict , __const char *__restrict ))fptr;
        }
        
    } // libdl.so

    if ( (IMG_Name(img).find("libncurses.so") != string::npos) ||
         (IMG_Name(img).find("LIBNCURSES.SO") != string::npos) ||
         (IMG_Name(img).find("LIBNCURSES.so") != string::npos) ) 
    {
        RTN rtngetch = RTN_FindByName(img, "getch");
        if (RTN_Valid(rtngetch) && RTN_IsSafeForProbedReplacement(rtngetch))
        {
            OutFile << CurrentTime() << "Inserting probe for getch at " << RTN_Address(rtngetch) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtngetch, AFUNPTR(mygetch)));
            fptrgetch = (int (*)())fptr;
        }
        
        RTN rtnmvgetch = RTN_FindByName(img, "mvgetch");
        if (RTN_Valid(rtnmvgetch) && RTN_IsSafeForProbedReplacement(rtnmvgetch))
        {
            OutFile << CurrentTime() << "Inserting probe for mvgetch at " << RTN_Address(rtnmvgetch) << endl;
            OutFile.flush();
            AFUNPTR fptr = (RTN_ReplaceProbed(rtnmvgetch, AFUNPTR(mymvgetch)));
            fptrmvgetch = (int (*)(int , int ))fptr;
        }
        
    } // libncurses.so

    // finished instrumentation
}
    
    
/* ===================================================================== */
/* Main function                                                         */
/* ===================================================================== */

int main(int argc, char *argv[])
{
    // Initialize Pin
    PIN_InitSymbols();
    if (PIN_Init(argc,argv))
    {
        return Usage();
    }
    
    OutFile.open(KnobOutputFile.Value().c_str());
    OutFile << hex;
    OutFile.setf(ios::showbase);
    OutFile << CurrentTime() << "started!" << endl;
    OutFile.flush();
    
    // Register the instrumentation callback
    IMG_AddInstrumentFunction(ImgLoad, 0);
    
    // Start the application
    PIN_StartProgramProbed(); // never returns
    
    return 0;
}
